/**
 * 
 */
package gov.va.genisis2.dao;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.StudyApproval;

/**
 * @author 586338
 *
 */
public interface IStudyApprovalDao {
	public int createStudyApproval(StudyApproval studyApproval) throws GenisisDAOException;

	public int updateStudyApproval(StudyApproval studyApproval) throws GenisisDAOException;

	public StudyApproval getStudyApprovalsByID(int id) throws GenisisDAOException;

	public List<StudyApproval> getStudyApprovalsByUID(String uid) throws GenisisDAOException;

	public List<StudyApproval> getStudyApprovals() throws GenisisDAOException;

	public StudyApproval saveOrUpdate(StudyApproval studyApproval) throws GenisisDAOException;
	
	public List<StudyApproval> getStudyApprovalsByTitle(String title) throws GenisisDAOException;
	
	public int updateStudyApprovalStatus(List<String> usersList) throws GenisisDAOException;
}
